// FuelManagement.h: Interface of Class CFuelManagement.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FUELMANAGEMENT_H__50425438_016A_4B41_AE19_23E2C9B72630__INCLUDED_)
#define AFX_FUELMANAGEMENT_H__50425438_016A_4B41_AE19_23E2C9B72630__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "orbitersdk.h"

#define NUM_EXT_TANKS 4
#define FUELPUMP_100PCNT_FLOWRATE 50.0
#define FUELPUMP_CHGSPEED 1.0

class CFuelManagement  
{
public:
	bool GetPropHandleFromValve(int iValve, PROPELLANT_HANDLE& ph);
	void FuelPumpSpeedChange(double dSimStep);
	void GetBrokenFuelMasses(double& dConnected, double& dDisconnected);
	void BreakUp();
	double GetTankFuelMass(int iTank);
	bool HasFuelPumpConnection(THRUSTER_HANDLE th) const;
	bool HasTankConnectionRearPart(THRUSTER_HANDLE th) const;
	void UpdateTankConnections();
	void LoadValveStates(char * pLoadString);
	void SetTankLvlNormalized(int iTank, double dLvl);
	void SaveValveStates(char * pSaveString);
	double GetTankLvlNormalized(int iTank);
	void UpdateThrRCSTankConnections();
	void UpdateThrMainTankConnections();
	enum {VLV_RCS, VLV_FRONT_HOVER, VLV_REAR_HOVER, VLV_RIGHT_AUX, VLV_LEFT_AUX, VLV_LEFT_MAIN, 
		VLV_RIGHT_MAIN, VLV_HOVER, VLV_AUX, VLV_MAIN, VLV_EXT1, VLV_EXT2, VLV_EXT3, VLV_EXT4, VLV_INT, 
		VLV_RCSPIPE, VLV_HATCHVENT, VLV_DOCK, NUMVALVES};
	enum {VLVST_OFF, VLVST_SRC, VLVST_DST, VLVST_DISABLED};
	int GetValveState(int iValve) const;
	void SetValveState(int iValve, int iValveState);
	void Timestep(double dSimTime);
	VESSEL* m_pVessel;
	void ToggleValve(int iValve);
	struct STank
	{	
		bool m_bPresent;
		double m_dMaxFuel;
		double m_dCurFuel;
		double m_dLastFuel;
		double m_dCurFlowRate;
		PROPELLANT_HANDLE m_ph;
	};
	enum {FPMODE_OFF, FPMODE_AUTO, FPMODE_MAN};
	struct SFuelPump
	{
		float m_fTargetLvl;
		float m_fActLvl;
		int m_iMode;
		float m_fCurFlowRate;
	} m_FuelPump;
	void Init(int* iCargoConf, VESSEL* pVessel);
	CFuelManagement();
	virtual ~CFuelManagement();

	enum {FTM_THR, FTM_EXT1, FTM_EXT2, FTM_EXT3, FTM_EXT4, FTM_INT, FTM_RCS, 
		FTM_DOCK, FTM_EXT, FTM_VENT, NUM_FTM_PORTS};

	enum{EXT1, EXT2, EXT3, EXT4, INT, RCS, NUMTANKS};
	STank m_arrTanks[NUMTANKS];

private:
	int m_arriValveStates[NUMVALVES];
	void ResetValveState(int iValveState, int iFromValve, int iToValve=NUMVALVES-1);
	int CheckValveState(int iValveState, int iFromValve, int iToValve=NUMVALVES-1) const;
};

#endif // !defined(AFX_FUELMANAGEMENT_H__50425438_016A_4B41_AE19_23E2C9B72630__INCLUDED_)
