// MainPanel.h: Interface for Class CMainPanel.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINPANEL_H__D4E1C43A_6FD7_4A4F_BD89_D67BC4DC7B6D__INCLUDED_)
#define AFX_MAINPANEL_H__D4E1C43A_6FD7_4A4F_BD89_D67BC4DC7B6D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Panel.h"

class CMainPanel : public CPanel  
{
public:
	double GetSliderThrustLevel(THRUSTER_HANDLE);
	UINT m_uiLeftSliderPosWant;
	void RedrawPanel_WarningLights(SURFHANDLE sh);
	UINT m_uiSliderpos_main[2], m_uiSliderpos_hovr[2], m_uiSliderpos_pod[2], m_uiPodswitch[2];
	virtual bool Redraw(int iID, int iEvent, SURFHANDLE sh);
	virtual bool MouseEvent(int iID, int iEvent, int iX, int iY);
	virtual void Init();
	virtual bool Load();
	CMainPanel(VESSEL* pVessel, int iPanelID);
	virtual ~CMainPanel();
	enum  
	{
		AID_MFD1_LBUTTONS,
		AID_MFD1_RBUTTONS,     
		AID_MFD1_BBUTTONS,     
		AID_MFD2_LBUTTONS,     
		AID_MFD2_RBUTTONS,     
		AID_MFD2_BBUTTONS,     
		AID_ENGINEMAIN,        
		AID_ENGINEHOVER,       
		AID_ENGINERETRO,       
		AID_ENGINEAUXHOVER,    
		AID_ENGINEPODLEVEL,    
		AID_ENGINEINDICATOR,   
		AID_PODANGLEINDICATOR, 
		AID_PODANGLESWITCH,    
		AID_NAVMODE,           
		AID_ATTITUDEMODE,      
		AID_AUXTHRUSTMODE,	  
		AID_OVERSPD_INDICATOR, 
		AID_WARNING_LIGHTS,
		NUM_AREANAMES
	};
	static const WORD s_pwBmpResIDs[4];
	static MFDSPEC s_mfds_left;
	static MFDSPEC s_mfds_right;

private:
	void RedrawPanel_MFDButton (SURFHANDLE surf, int mfd, int side);
	void RedrawPanel_Navmode (SURFHANDLE surf);
	bool RedrawPanel_Throttle (SURFHANDLE surf);
	bool RedrawPanel_Hover (SURFHANDLE surf);
	bool RedrawPanel_Podlevel (SURFHANDLE surf);
	bool RedrawPanel_EngineIndicator (SURFHANDLE surf);
	bool RedrawPanel_PodangleIndicator (SURFHANDLE surf);
	void RedrawPanel_AuxThrustMode (SURFHANDLE surf);
	void RedrawPanel_OvrSpdIndicator(SURFHANDLE surf);
};

#endif // !defined(AFX_MAINPANEL_H__D4E1C43A_6FD7_4A4F_BD89_D67BC4DC7B6D__INCLUDED_)
