// Radar.cpp: Implementation of Class CRadar.
//
//////////////////////////////////////////////////////////////////////

#include <math.h>
#include "Radar.h"



CRadar::CRadar(VESSEL* pVessel)
{
	m_pVessel = pVessel;
	m_puiMeshGroups = NULL;
	m_iNumGroups = 0;
	m_uiAnimSeq = 0;
	m_dLastAngle = m_dCurAngle = 3*PI/2;
	m_bWrecked = false;
	m_bActive = false;
}

CRadar::~CRadar()
{
	if(m_puiMeshGroups)
		delete m_puiMeshGroups;
}

void CRadar::RegisterAnimation(UINT* puiMeshGroups, int iNumGroups, int iMesh)
{
	m_puiMeshGroups = new UINT[iNumGroups];
	for(int i=0;i<iNumGroups;i++)
		m_puiMeshGroups[i] = puiMeshGroups[i];
	m_iNumGroups = iNumGroups;

	m_anmcRot.grp = m_puiMeshGroups;
	m_anmcRot.ngrp = m_iNumGroups;
	m_anmcRot.state0 = 0.0;
	m_anmcRot.state1 = 1.0;
	m_anmcRot.trans.P.rotparam.ref = _V(0.0, 0.0, 12.969);
	m_anmcRot.trans.P.rotparam.axis = _V(0.0, 1.0, 0.0);
	m_anmcRot.trans.P.rotparam.angle = (float) (2*PI);
	m_anmcRot.trans.nmesh = iMesh;
	m_anmcRot.trans.ngrp = 0;
	m_anmcRot.trans.transform = MESHGROUP_TRANSFORM::ROTATE;

	m_uiAnimSeq = m_pVessel->RegisterAnimSequence (0.75);
	m_pVessel->AddAnimComp (m_uiAnimSeq, &m_anmcRot);
	
}

void CRadar::Timestep(double dSimtime)
{
	int iIndex;

	if(!m_bActive || m_bWrecked)
		return;

	MAP_OBJH2RadObj::iterator iterator;
	if(m_mapRadarObjects.size() != oapiGetObjectCount())
	{
		OBJHANDLE oh;
		// rebuild map
		MAP_OBJH2RadObj mapTmpRadObjs;
		for(iIndex = 0;iIndex < oapiGetObjectCount();iIndex++)
		{
			oh = oapiGetObjectByIndex(iIndex);
			if(oh != oapiGetFocusObject())
			{
				if((iterator = m_mapRadarObjects.find(oh)) != m_mapRadarObjects.end())
					mapTmpRadObjs.insert(MAP_OBJH2RadObj::value_type(*iterator));
				else
					mapTmpRadObjs.insert(MAP_OBJH2RadObj::value_type(oh, SRadObject()));

			}
		}
		m_mapRadarObjects = mapTmpRadObjs;
	}

	VECTOR3 vecGlobal, vecLocal;
	double dObjAngle; 
	if(m_dLastUpdateTime + 1.0 < dSimtime)
	{
		for(iterator = m_mapRadarObjects.begin(); iterator != m_mapRadarObjects.end(); iterator++)
		{
			oapiGetGlobalPos(iterator->first, &vecGlobal);
			m_pVessel->Global2Local(vecGlobal, vecLocal);
			dObjAngle = atan(vecLocal.z/vecLocal.x);
			if(vecLocal.x < 0.0)
				dObjAngle = PI/2 + dObjAngle;
			else
				dObjAngle = 3*PI/2 + dObjAngle;
			iterator->second.m_dAngle2D = dObjAngle;
			double dXZSquare = vecLocal.x*vecLocal.x + vecLocal.z*vecLocal.z;
			iterator->second.m_dDistance2D = sqrt(dXZSquare);
			iterator->second.m_dDistance3D = sqrt(dXZSquare + vecLocal.y*vecLocal.y);
			iterator->second.m_dEclipticAngle = asin(vecLocal.y);
			iterator->second.m_dSize = oapiGetSize(iterator->first);
			iterator->second.m_bValid = true;
		}
		m_dLastUpdateTime = dSimtime;
	}
}

void CRadar::SetWrecked(bool bWrecked)
{
	m_bWrecked = bWrecked;
}

bool CRadar::IsWrecked()
{
	return m_bWrecked;
}

MAP_OBJH2RadObj* CRadar::GetRadObjs()
{
	return &m_mapRadarObjects;
}

double CRadar::GetCurAngle()
{
	return m_dCurAngle;
}

bool CRadar::IsActive()
{
	return m_bActive;
}

void CRadar::ToggleActive()
{
	m_bActive = !m_bActive;
}

void CRadar::SetActive(bool bActive)
{
	m_bActive = bActive;
}

void CRadar::SetCurAngle(double dAngle)
{
	m_dCurAngle = m_dLastAngle = dAngle;
}
