// Radar.h: Interface for Class CRadar.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RADAR_H__71905452_4B09_4EBA_A309_A1E2F3E9332E__INCLUDED_)
#define AFX_RADAR_H__71905452_4B09_4EBA_A309_A1E2F3E9332E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma warning( disable : 4786)

#include "orbitersdk.h"
#include <map>

struct SRadObject
{
	SRadObject() : m_dAngle2D(0), m_dEclipticAngle(0), 
		m_dDistance2D(0), m_dDistance3D(0), m_dSize(0), 
		m_bValid(false) {}
	double m_dAngle2D;
	double m_dEclipticAngle;
	double m_dDistance2D;
	double m_dDistance3D;
	double m_dSize;
	bool m_bValid;
};

using namespace std;
typedef map<OBJHANDLE, SRadObject> MAP_OBJH2RadObj;


const double RADAR_ROTATION_SPEED = PI/2;

class CRadar  
{
public:
	double m_dLastUpdateTime;
	void SetCurAngle(double dAngle);
	void SetActive(bool bActive);
	void ToggleActive();
	bool IsActive();
	double GetCurAngle();
	double m_dLastAngle;
	MAP_OBJH2RadObj* GetRadObjs();
	bool m_bActive;
	bool IsWrecked();
	void SetWrecked(bool bWrecked = true);
	bool m_bWrecked;
	void Timestep(double dSimtime);
	void RegisterAnimation(UINT* puiMeshGroups, int iNumGroups, int iMesh);
	CRadar(VESSEL* pVessel);
	virtual ~CRadar();

protected:
	MAP_OBJH2RadObj m_mapRadarObjects;
	VESSEL* m_pVessel;
	UINT *m_puiMeshGroups;
	int m_iNumGroups;
	UINT m_uiAnimSeq;
	double m_dCurAngle;
	ANIMCOMP m_anmcRot;

};

#endif // !defined(AFX_RADAR_H__71905452_4B09_4EBA_A309_A1E2F3E9332E__INCLUDED_)
