// MainPanel.cpp: Implementierung der Klasse CMainPanel.
//
//////////////////////////////////////////////////////////////////////

#include "MainPanel.h"
#include "ShuttleA.h"
#include "resource.h"
#include "stdio.h"
#include "math.h"

extern GDIParams g_Param;

const WORD CMainPanel::s_pwBmpResIDs[4] = {IDB_SLIDER1, IDB_SWITCH1, IDB_BUTTON1, IDB_WARNINGLIGHTS};

MFDSPEC CMainPanel::s_mfds_left  = {{ 66, 84,  326, 344}, 6, 6, 31, 38};
MFDSPEC CMainPanel::s_mfds_right = {{828, 84, 1088, 344}, 6, 6, 31, 38};


CMainPanel::CMainPanel(VESSEL* pVessel, int iPanelID) : CPanel(pVessel, iPanelID, NUM_AREANAMES, s_pwBmpResIDs, 4)
{
	m_uiLeftSliderPosWant = 90;
}

CMainPanel::~CMainPanel()
{

}

bool CMainPanel::Load()
{
	HBITMAP hBmp = LoadBitmap (g_Param.hDLL, MAKEINTRESOURCE (IDB_PANEL1));
	if(!hBmp)
		return false;

	oapiRegisterPanelBackground (hBmp, PANEL_ATTACH_BOTTOM|PANEL_MOVEOUT_BOTTOM, 0xffffff);
	oapiSetPanelNeighbours (-1,-1,1,-1);
	oapiRegisterMFD (MFD_LEFT, s_mfds_left);
	oapiRegisterMFD (MFD_RIGHT, s_mfds_right);
	oapiRegisterPanelArea (AreaID(AID_ENGINEMAIN),        _R( 414,  43, 467, 242), PANEL_REDRAW_ALWAYS, PANEL_MOUSE_LBDOWN|PANEL_MOUSE_LBPRESSED, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_ENGINEHOVER),       _R( 504,  43, 557, 242), PANEL_REDRAW_ALWAYS, PANEL_MOUSE_LBDOWN|PANEL_MOUSE_LBPRESSED, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_ENGINEPODLEVEL),    _R( 414, 250, 467, 359), PANEL_REDRAW_ALWAYS, PANEL_MOUSE_LBDOWN|PANEL_MOUSE_LBPRESSED, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_ENGINEINDICATOR),   _R( 584,  47, 709, 237), PANEL_REDRAW_ALWAYS, PANEL_MOUSE_IGNORE, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_PODANGLEINDICATOR), _R( 494, 310, 630, 351), PANEL_REDRAW_ALWAYS, PANEL_MOUSE_IGNORE, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_PODANGLESWITCH),    _R( 523, 263, 568, 307), PANEL_REDRAW_MOUSE, PANEL_MOUSE_LBDOWN|PANEL_MOUSE_LBPRESSED|PANEL_MOUSE_LBUP, PANEL_MAP_CURRENT);
	oapiRegisterPanelArea (AreaID(AID_NAVMODE),           _R( 112,  17, 374,  48), PANEL_REDRAW_USER, PANEL_MOUSE_LBDOWN, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_ATTITUDEMODE),      _R( 719,  62, 739, 106), PANEL_REDRAW_MOUSE, PANEL_MOUSE_DOWN);
	oapiRegisterPanelArea (AreaID(AID_MFD1_LBUTTONS),     _R(  28, 109,  52, 318), PANEL_REDRAW_USER, PANEL_MOUSE_LBDOWN|PANEL_MOUSE_LBPRESSED, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_MFD1_RBUTTONS),     _R( 338, 109, 362, 318), PANEL_REDRAW_USER, PANEL_MOUSE_LBDOWN|PANEL_MOUSE_LBPRESSED, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_MFD1_BBUTTONS),     _R( 129, 349, 262, 368), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN);
	oapiRegisterPanelArea (AreaID(AID_MFD2_LBUTTONS),     _R( 790, 109, 814, 318), PANEL_REDRAW_USER, PANEL_MOUSE_LBDOWN|PANEL_MOUSE_LBPRESSED, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_MFD2_RBUTTONS),     _R(1100, 109,1124, 318), PANEL_REDRAW_USER, PANEL_MOUSE_LBDOWN|PANEL_MOUSE_LBPRESSED, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_MFD2_BBUTTONS),     _R( 891, 349,1024, 368), PANEL_REDRAW_NEVER, PANEL_MOUSE_LBDOWN);
	oapiRegisterPanelArea (AreaID(AID_AUXTHRUSTMODE),     _R( 645, 252, 687, 359), PANEL_REDRAW_ALWAYS, PANEL_MOUSE_LBDOWN, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_OVERSPD_INDICATOR), _R( 715, 113, 758, 243), PANEL_REDRAW_ALWAYS, PANEL_MOUSE_IGNORE, PANEL_MAP_BACKGROUND);
	oapiRegisterPanelArea (AreaID(AID_WARNING_LIGHTS),	  _R( 398,   7, 755,  28), PANEL_REDRAW_ALWAYS, PANEL_MOUSE_LBDOWN, PANEL_MAP_BACKGROUND);
	return true;
}

void CMainPanel::Init()
{
	for (int i = 0; i < 2; i++) 
	{
		m_uiSliderpos_main[i] = m_uiSliderpos_hovr[i] =
		m_uiSliderpos_pod[i] = (UINT) -1;
		m_uiPodswitch[i] = 0;
	}
}

bool CMainPanel::MouseEvent(int iID, int iEvent, int iX, int iY)
{
	int iIndex = AreaIndex(iID);
	if(iIndex < 0)
		return false;

	int iMode, piMode, iMfd;
	static int iCtrl = 3;
	double dLvl;
	ShuttleA* pSh = (ShuttleA*) m_pVessel;

	switch(iIndex)
	{
	case AID_MFD1_LBUTTONS:
	case AID_MFD1_RBUTTONS:
	case AID_MFD2_LBUTTONS:
	case AID_MFD2_RBUTTONS:
		if (iY%39 < 20) {
			iMfd = (iIndex <= AID_MFD1_RBUTTONS ? MFD_LEFT : MFD_RIGHT);
			int bt = iY/39 + (iIndex == AID_MFD1_LBUTTONS || iIndex == AID_MFD2_LBUTTONS ? 0 : 6);
			oapiProcessMFDButton (iMfd, bt, iEvent);
			return true;
		}
		break;
	case AID_MFD1_BBUTTONS:
	case AID_MFD2_BBUTTONS:
		iMfd = (iIndex == AID_MFD1_BBUTTONS ? MFD_LEFT : MFD_RIGHT);
		if      (iX <  32)            oapiToggleMFD_on (iMfd);
		else if (iX >= 50 && iX < 82) oapiSendMFDKey (iMfd, OAPI_KEY_F1);
		else if (iX >= 100)           oapiSendMFDKey (iMfd, OAPI_KEY_GRAVE);
		return true;
	case AID_ENGINEMAIN:
		if (iEvent & PANEL_MOUSE_LBDOWN) { // record which sliIDer to operate
			if      (iX <  12) iCtrl = 1;  // left engine
			else if (iX >= 41) iCtrl = 2;  // right engine
			else               iCtrl = 3;  // both
		}
		if ((iY -= 9) < 0) dLvl = 1.0;
		else if (iY > 180) dLvl = 0.0;
		else               dLvl = 1.0-iY/180.0;
		if (iCtrl & 1) pSh->SetThrusterLevel (pSh->th_main[0], dLvl);
		if (iCtrl & 2) pSh->SetThrusterLevel (pSh->th_main[1], dLvl);
		return true;
	case AID_ENGINEHOVER:
		if (iEvent & PANEL_MOUSE_LBDOWN) { // record which sliIDer to operate
			if      (iX <  12) iCtrl = 1;  // front engine
			else if (iX >= 41) iCtrl = 2;  // back engine
			else               iCtrl = 3;  // both
		}
		if ((iY -= 9) < 0) dLvl = 1.0;
		else if (iY > 180) dLvl = 0.0;
		else               dLvl = 1.0-iY/180.0;
		if (iCtrl & 1) pSh->SetThrusterLevel (pSh->th_hover[0], dLvl);
		if (iCtrl & 2) pSh->SetThrusterLevel (pSh->th_hover[1], dLvl);
		return true;
	case AID_ENGINEPODLEVEL:
		if (iEvent & PANEL_MOUSE_LBDOWN) { // record which sliIDer to operate
			if      (iX <  12) iCtrl = 1;  // left engine
			else if (iX >= 41) iCtrl = 2;  // right engine
			else               iCtrl = 3;  // both
		}
		if ((iY -= 9) < 0) dLvl = 1.0;
		else if (iY > 90)  dLvl = 0.0;
		else               dLvl = 1.0-iY/90.0;
		if (iCtrl & 1) 
		{
			if(!pSh->m_bAuxPodDmg)
				pSh->SetThrusterLevel(pSh->th_pod[0], dLvl);
		}
		if (iCtrl & 2) 
		{
			pSh->SetThrusterLevel(pSh->th_pod[1], dLvl);
		}
		return true;
	case AID_PODANGLESWITCH:
		if (iEvent & PANEL_MOUSE_LBDOWN) { // record which switch to operate
			if      (iX <   8) iCtrl = 1;  // left pod
			else if (iX >= 34) iCtrl = 2;  // right pod
			else               iCtrl = 3;  // both
		}
		piMode = ((iCtrl & 1) ? m_uiPodswitch[0] : m_uiPodswitch[1]);
		if (iEvent & PANEL_MOUSE_LBUP) iMode = 0;
		else                          iMode = (iY < 22 ? 1:2);
		if (iCtrl & 1) pSh->RotatePod (0, m_uiPodswitch[0] = iMode);
		if (iCtrl & 2) pSh->RotatePod (1, m_uiPodswitch[1] = iMode);
		return iMode != piMode;
	case AID_NAVMODE:
		if ((iX % 44) < 42) {
			pSh->ToggleNavmode (6 - iX/44);
			return true;
		}
		break;
	case AID_ATTITUDEMODE:
		piMode = pSh->GetAttitudeMode();
		if (iY < 22) {
			static int niMode[3] = {1,2,2};
			iMode = niMode[piMode];
		} else {
			static int niMode[3] = {0,0,1};
			iMode = niMode[piMode];
		}
		if (iMode != piMode) pSh->SetAttitudeMode (iMode);
		return iMode != piMode;
	case AID_AUXTHRUSTMODE:
		pSh->ToggleAuxThrustMode(iY/38);
		return true;
	case AID_WARNING_LIGHTS:
		if(iX <= 101)
			pSh->SetOvrSpeedAlarm(false);
		if(iX >= 108 && iX <= 209)
			pSh->SetHullTempAlarm(false);
		if(iX >= 216)
			pSh->SetDmgAlarm(false);
		return true;
	}
	return false;
}

bool CMainPanel::Redraw(int iID, int iEvent, SURFHANDLE sh)
{
	int iIndex = AreaIndex(iID);
	if(iIndex < 0)
		return false;

	ShuttleA* pSh = (ShuttleA*) m_pVessel;

	switch(iIndex)
	{
	case AID_MFD1_LBUTTONS:
		RedrawPanel_MFDButton (sh, MFD_LEFT, 0);
		return true;
	case AID_MFD1_RBUTTONS:
		RedrawPanel_MFDButton (sh, MFD_LEFT, 1);
		return true;
	case AID_MFD2_LBUTTONS:
		RedrawPanel_MFDButton (sh, MFD_RIGHT, 0);
		return true;
	case AID_MFD2_RBUTTONS:
		RedrawPanel_MFDButton (sh, MFD_RIGHT, 1);
		return true;
	case AID_ENGINEMAIN:
		return RedrawPanel_Throttle (sh);
	case AID_ENGINEHOVER:
		return RedrawPanel_Hover (sh);
	case AID_ENGINEPODLEVEL:
		return RedrawPanel_Podlevel (sh);
	case AID_ENGINEINDICATOR:
		return RedrawPanel_EngineIndicator (sh);
	case AID_PODANGLEINDICATOR:
		return RedrawPanel_PodangleIndicator (sh);
	case AID_PODANGLESWITCH:
		oapiBlt (sh, SurfHandle(1),  0, 0, m_uiPodswitch[0]*20, 0, 20, 44);
		oapiBlt (sh, SurfHandle(1), 24, 0, m_uiPodswitch[1]*20, 0, 20, 44);
		return true;
	case AID_NAVMODE:
		RedrawPanel_Navmode (sh);
		return true;
	case AID_ATTITUDEMODE:
		oapiBlt (sh, SurfHandle(1), 0, 0, ((pSh->GetAttitudeMode()+2)%3)*20, 0, 20, 44);
		return true;
	case AID_AUXTHRUSTMODE:
		RedrawPanel_AuxThrustMode (sh);
		return true;
	case AID_OVERSPD_INDICATOR:
		RedrawPanel_OvrSpdIndicator (sh);
		return true;
	case AID_WARNING_LIGHTS:
		RedrawPanel_WarningLights(sh);
		return true;
	}

	return false;
}

void CMainPanel::RedrawPanel_MFDButton (SURFHANDLE sh, int mfd, int side)
{
	HDC hDC = oapiGetDC (sh);
	SelectObject (hDC, g_Param.hFont[0]);
	SetTextColor (hDC, RGB(0, 200, 0));
	SetTextAlign (hDC, TA_CENTER);
	SetBkMode (hDC, TRANSPARENT);
	const char *label;
	for (int bt = 0; bt < 6; bt++) {
		if (label = oapiMFDButtonLabel (mfd, bt+side*6))
			TextOut (hDC, 13, 3+38*bt, label, strlen(label));
		else break;
	}
	oapiReleaseDC (sh, hDC);
}

void CMainPanel::RedrawPanel_Navmode (SURFHANDLE sh)
{
	ShuttleA* pSh = (ShuttleA*) m_pVessel;
	for (DWORD i = NAVMODE_KILLROT; i < NAVMODE_HOLDALT; i++)
		if (pSh->GetNavmodeState (i))
			oapiBlt (sh, SurfHandle(2), (6-i)*44, 0, (i-1)*42, 0, 42, 31);
}

bool CMainPanel::RedrawPanel_Throttle (SURFHANDLE sh)
{
	UINT i, pos;
	bool redraw = false;
	ShuttleA* pSh = (ShuttleA*) m_pVessel;

	for (i = 0; i < 2; i++) {
		double level = pSh->GetThrusterLevel (pSh->th_main[i]);
		pos = (UINT)((1.0-level)*180.0);
		if (pos != m_uiSliderpos_main[i])
			m_uiSliderpos_main[i] = pos, redraw = true;
	}
	if (redraw)
		for (i = 0; i < 2; i++)
			oapiBlt (sh, SurfHandle(0), i*30, m_uiSliderpos_main[i], 0, 0, 23, 19);
	return redraw;
}

bool CMainPanel::RedrawPanel_Hover (SURFHANDLE sh)
{
	UINT i, pos;
	bool redraw = false;
	ShuttleA* pSh = (ShuttleA*) m_pVessel;

	for (i = 0; i < 2; i++) {
		double level = pSh->GetThrusterLevel (pSh->th_hover[i]);
		pos = (UINT)((1.0-level)*180.0);
		if (pos != m_uiSliderpos_hovr[i])
			m_uiSliderpos_hovr[i] = pos, redraw = true;
	}
	if (redraw)
		for (i = 0; i < 2; i++)
			oapiBlt (sh, SurfHandle(0), i*30, m_uiSliderpos_hovr[i], 0, 0, 23, 19);
	return redraw;
}

bool CMainPanel::RedrawPanel_Podlevel (SURFHANDLE sh)
{
	UINT i, pos;
	bool redraw = false;
	ShuttleA* pSh = (ShuttleA*) m_pVessel;

	for (i = 0; i < 2; i++) {
		double level = pSh->m_arrpAuxThrusters[i]->GetThrustLevel();
			pos = (UINT)((1.0-level)*90.0);
		if (pos != m_uiSliderpos_pod[i])
			m_uiSliderpos_pod[i] = pos, redraw = true;
	}
	if (redraw)
		for (i = 0; i < 2; i++)
			oapiBlt (sh, SurfHandle(0), i*30, m_uiSliderpos_pod[i], 0, 0, 23, 19);
	return redraw;
}

bool CMainPanel::RedrawPanel_EngineIndicator (SURFHANDLE sh)
{
	ShuttleA* pSh = (ShuttleA*) m_pVessel;
	const double rad = 25.0;
	const int cntx[2] = {29, 95};
	const int txtx[2] = {16, 83};
	const int cnty[3] = {29, 96, 163};
	const int txty0a =  34, txty0b =  46;
	const int txty1a = 101, txty1b = 113;
	const int txty2a = 168, txty2b = 180;

	UINT i;
	double level, th, angle, dx, dy;
	char cbuf[16];
	double m = pSh->GetMass();

	HDC hDC = oapiGetDC (sh);
	SelectObject (hDC, g_Param.hFont[0]);
	SelectObject (hDC, g_Param.hPen[0]);
	SetTextColor (hDC, RGB(120,220,120));
	SetTextAlign (hDC, TA_RIGHT);
	SetBkMode (hDC, TRANSPARENT);

	for (i = 0; i < 2; i++) {
		level = pSh->GetThrusterLevel (pSh->th_main[i]);
		th    = level*MAX_MAIN_THRUST;
		angle = level * (1.5*PI);
		dx = rad*cos(angle), dy = rad*sin(angle);
		MoveToEx (hDC, cntx[i], cnty[0], NULL);
		LineTo (hDC, cntx[i]-(int)dx, cnty[0]-(int)dy);
		sprintf (cbuf, "%0.0f", th*1e-3);
		TextOut (hDC, txtx[i], txty0a, cbuf, strlen(cbuf));
		sprintf (cbuf, "%0.1f", th/m);
		TextOut (hDC, txtx[i], txty0b, cbuf, strlen (cbuf));

		level = pSh->GetThrusterLevel (pSh->th_hover[i]);
		th    = level*MAX_HOVER_THRUST;
		angle = level * (1.5*PI);
		dx = rad*cos(angle), dy = rad*sin(angle);
		MoveToEx (hDC, cntx[i], cnty[1], NULL);
		LineTo (hDC, cntx[i]-(int)dx, cnty[1]-(int)dy);
		sprintf (cbuf, "%0.0f", th*1e-3);
		TextOut (hDC, txtx[i], txty1a, cbuf, strlen(cbuf));
		sprintf (cbuf, "%0.1f", th/m);
		TextOut (hDC, txtx[i], txty1b, cbuf, strlen (cbuf));

		level = pSh->GetThrusterLevel (pSh->th_pod[i]);
		th    = level*MAX_RETRO_THRUST;
		angle = level * (1.5*PI);
		dx = rad*cos(angle), dy = rad*sin(angle);
		MoveToEx (hDC, cntx[i], cnty[2], NULL);
		LineTo (hDC, cntx[i]-(int)dx, cnty[2]-(int)dy);
		sprintf (cbuf, "%0.0f", th*1e-3);
		TextOut (hDC, txtx[i], txty2a, cbuf, strlen(cbuf));
		sprintf (cbuf, "%0.1f", th/m);
		TextOut (hDC, txtx[i], txty2b, cbuf, strlen (cbuf));
	}
	oapiReleaseDC (sh, hDC);

	return true;
}

bool CMainPanel::RedrawPanel_PodangleIndicator (SURFHANDLE sh)
{
	ShuttleA* pSh = (ShuttleA*) m_pVessel;
	const int cntx[2] = {32,102}, cnty = 13;
	const int txtx[2] = {3,73}, txty =  0;
	const double rad = 24.0;

	UINT i;
	double angle, dAngleWant;
	char cbuf[16];

	HDC hDC = oapiGetDC (sh);
	SelectObject (hDC, g_Param.hFont[0]);
	SetTextColor (hDC, RGB(120,220,120));
	SetBkMode (hDC, TRANSPARENT);

	for (i = 0; i < 2; i++) {
		SelectObject (hDC, g_Param.hPen[1]);
		dAngleWant = pSh->m_arrpAuxThrusters[i]->GetThrustDirWant();
		MoveToEx (hDC, cntx[i], cnty, NULL);
		LineTo (hDC, cntx[i]-(int)(0.8*rad*cos(dAngleWant)), cnty+(int)(0.8*rad*sin(dAngleWant)));
	
		SelectObject (hDC, g_Param.hPen[0]);
		angle = pSh->m_arrpAuxThrusters[i]->GetThrustDir();
		MoveToEx (hDC, cntx[i], cnty, NULL);
		LineTo (hDC, cntx[i]-(int)(rad*cos(angle)), cnty+(int)(rad*sin(angle)));
		sprintf (cbuf, "%02.0f", DEG*angle);
		TextOut (hDC, txtx[i], txty, cbuf, strlen(cbuf));
	}
	oapiReleaseDC (sh, hDC);
	return true;
}

void CMainPanel::RedrawPanel_AuxThrustMode (SURFHANDLE sh)
{
	ShuttleA* pSh = (ShuttleA*) m_pVessel;
	double dSimTime = oapiGetSimTime();

	switch(pSh->AuxPodsState())
	{
	case ShuttleA::RETRO:
		oapiBlt (sh, SurfHandle(2), 0, 0, 6*42, 0, 42, 31);
		break;
	case ShuttleA::HOVER:
		oapiBlt (sh, SurfHandle(2), 0, 38, 7*42, 0, 42, 31);
		break;
	case ShuttleA::MAIN:
		oapiBlt (sh, SurfHandle(2), 0, 2*38, 8*42, 0, 42, 31);
		break;
	case ShuttleA::MOVETO_RETRO:
		if(GetBlinkStatus())
			oapiBlt (sh, SurfHandle(2), 0, 0, 6*42, 0, 42, 31);
		break;
	case ShuttleA::MOVETO_HOVER:
		if(GetBlinkStatus())
			oapiBlt (sh, SurfHandle(2), 0, 38, 7*42, 0, 42, 31);
		break;
	case ShuttleA::MOVETO_MAIN:
		if(GetBlinkStatus())
			oapiBlt (sh, SurfHandle(2), 0, 2*38, 8*42, 0, 42, 31);
		break;
	}
}

void CMainPanel::RedrawPanel_OvrSpdIndicator(SURFHANDLE surf)
{
	char cbuf[5];
	ShuttleA* pSh = (ShuttleA*) m_pVessel;
	double dOverSpeed = pow(pSh->m_dOverSpeed, 2);
	double dDummy;

	HDC hDC = oapiGetDC (surf);
	SelectObject (hDC, g_Param.hBrush[0]);
	SelectObject (hDC, g_Param.hFont[0]);
	SetTextColor (hDC, RGB(120,220,120));
	SetBkMode (hDC, TRANSPARENT);
	dDummy = 99.0 - (dOverSpeed/1.21)*74.0;
	Rectangle (hDC,  20, 99, 40, (int) max(dDummy, 64.6));
	if(dOverSpeed > 0.5625)
	{
		SelectObject (hDC, g_Param.hBrush[1]);
		Rectangle (hDC,  20, 65, 40, (int) max(dDummy, 49.5));
	}
	if(dOverSpeed > 0.81)
	{
		SelectObject (hDC, g_Param.hBrush[2]);
		if(dOverSpeed <= 1.0 || GetBlinkStatus(3.0, 0.7))
			Rectangle (hDC,  20, 50, 40, (int) max(dDummy, 25.0));
	}

	sprintf (cbuf, "%3.0f", pSh->m_dOverSpeed*100.0);
	TextOut (hDC, 4, 12, cbuf, strlen(cbuf));

	sprintf (cbuf, "%4.0f", pSh->m_dHullTemp);
	SetTextColor (hDC, RGB(max(0.0, min(255, (int) (pSh->m_dHullTemp-400.0)*1.2)),
		max(0, min(255, (int) (800.0-pSh->m_dHullTemp)*1.2)),0));
	SetTextAlign (hDC, TA_RIGHT);
	TextOut (hDC, 32, 115, cbuf, strlen(cbuf));

	oapiReleaseDC (surf, hDC);
}

void CMainPanel::RedrawPanel_WarningLights(SURFHANDLE sh)
{
	ShuttleA* pSh = (ShuttleA*) m_pVessel;
	if	(pSh->m_dOverSpeed > 0.8 
		&&
			(
				(pSh->m_dOverSpeed < 0.9)
				|| (pSh->m_dOverSpeed < 0.95 && GetBlinkStatus(1.0))
				|| (pSh->m_dOverSpeed >= 0.95 && pSh->m_dOverSpeed < 1.0 && GetBlinkStatus(2.0))
				|| (pSh->m_dOverSpeed >= 1.0 && GetBlinkStatus(3.0))
			)
		)
	{
		oapiBlt (sh, SurfHandle(3), 0, 0, 0, 0, 101, 20);
	}

	if(pSh->m_dHullTemp > 550.0
		&&
			(
				(pSh->m_dHullTemp < 600.0)
				|| (pSh->m_dHullTemp < 650.0 && GetBlinkStatus(1.0))
				|| (pSh->m_dHullTemp >= 650.0 && pSh->m_dHullTemp < 700.0 && GetBlinkStatus(2.0))
				|| (pSh->m_dHullTemp >= 700.0 && GetBlinkStatus(3.0))
			)
		)
	{
		oapiBlt (sh, SurfHandle(3), 108, 0, 245, 0, 101, 20);
	}

	if(pSh->m_bAuxPodDmg && GetBlinkStatus(2.0))
		oapiBlt (sh, SurfHandle(3), 216, 0, 103, 0, 140, 20);
}

double CMainPanel::GetSliderThrustLevel(THRUSTER_HANDLE th)
{
	ShuttleA* pSh = (ShuttleA*) m_pVessel;
	if(th == pSh->th_hover[0])	
		return 1.0-m_uiSliderpos_hovr[0]/180.0;

	if(th == pSh->th_hover[1])
		return 1.0-m_uiSliderpos_hovr[1]/180.0;

	if(th == pSh->th_pod[1])
		return 1.0-m_uiSliderpos_pod[1]/90.0;

	if(th == pSh->th_pod[0])
		return 1.0-m_uiSliderpos_pod[0]/90.0;

	if(th == pSh->th_main[0])
		return 1.0-m_uiSliderpos_main[0]/180.0;

	if(th == pSh->th_main[1])
		return 1.0-m_uiSliderpos_main[1]/180.0;

	return 0.0;
}
